require("scripts/chocshopstyle.lua");
require("scripts/transitions.lua");
require("scripts/rewards.lua");

local sw_closed = false;

function CloseSweetRewards()
    --if( not sw_closed )then
        --sw_closed = true;
        SetState("SweetRewardsScreenTime", 0);
        CloseWindow();
        if(gDialogTable.context == "worldmap" or gDialogTable.context == "game") then
            --DoTransition( kFadeFromBlack );
            PostMessage( CreateNamedMessage( kFadeFromBlack, '' ) );
            SetState("MetaMapScreenTime", 1);
        end
    --end
end

MakeDialog{
    name = "rewards_dialog",
    
    --RBounceWindow
    RWindow
    {
        x = 0,
        y = 0, --kCenter - 600,
        w = 800,
        h = 600,     
        --targetposx	= 0,
		--targetposy	= 0,
		alpha = false,
		--bouncelen	= 400,
		--bouncefunc	= "sincx",
		image = "ui/rewards/background",
		
		VRewardsWindow{
		    alpha = true,
		    x = 0, y = 0, w = kMax, h = kMax,
		    box_top = {
		        x = 0, y = 0,
		        spriteLayer = 100,
		        baseDir = "ui/rewards/",
		        assets = {
		            top = {
		                {state="default", file="box_top"},
		            },
		        },
		    },
		    rewards = sweet_rewards,
		},
		
		-------------------------------------------------Header text
		Text{
		    x = 10,
		    y = 0,
		    w = 350,
		    h = 50,
		    font = {edwardian_medium, 46, Color(182,138,63)},
		    flags = kHAlignLeft + kVAlignTop,
		    label = "#<outline color='000000' size=6>"..GetString("mainmenu_sweet").." "..GetString("mainmenu_rewards").."</outline>",
		},
		-------------------------------------------------Close Button
		SetStyle(CSMMCenterButtonStyle),
		Button
        {
			x		= 676,
            y		= 502,
			Text{
				font    = {edwardian_medium, 24, WhiteColor},
				x		= 0,
				y		= 0,
				w		= kMax - 3,
				h		= kMax - 5,
				flags	= kHAlignCenter + kVAlignCenter,
				label	= "app_ok"
			},
            command =
				function()
					DoTransition( kFadeToBlack );
					SetState("SweetRewardsScreenTime", 0);
                    if(gDialogTable.context == "worldmap" or gDialogTable.context == "game") then
                        SetState("MetaMapScreenTime", 1);
                        PostMessage( CreateNamedMessage( kFadeFromBlack, '' ) );
                    end
                    CloseWindow();
				end
        },
    },
}
PostMessage( CreateNamedMessage( kFadeFromBlack, "RewardWindowReady();" ) );
SetState("SweetRewardsScreenTime", 1);